@extends('layouts.master')

@section('title', 'Calander | Proxima - Medical Management app')

@section('title-topbar', __('basic.calendar'))

<!-- css insert -->
@section('css')

<!-- select 2 -->
<link href="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />

<!-- boostrap datepicker -->
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/css/bootstrap-datepicker3.css" />

@endsection

@section('fixedcontent')

<div id="add_buttn_fixed">
    <a href="{{ route('sett.appointment.create') }}" class="text-white">
        <i class="fas fa-plus"></i>
    </a>
</div>

<!-- session successful message -->
@if (Session::has('success'))
<div id="flash-msg" class="shadow pt-3">
    <div class="d-flex justify-content-between mb-2">
        <i class="fas fs-1 fa-check"></i>
        <a id="flash-msg-btn" class="text-blue-300 clickable-item-pointer"><i class="fas fa-times"></i></a>
    </div>
    <h3>Sent Successfully</h3>
    <p class="text-blue-300">{{ Session::get('success') }}</p>
</div>
@endif

@endsection


<!-- content insert -->
@section('content')

<div class="container-fluid px-1 mt-3">

    <!-- page title link -->
    <div class="d-sm-flex align-items-center justify-content-between mb-4 mb-md-3">

        <div class="calendar-datepicker mb-2 mb-md-0">
            <div class="input-group">
                <div class="input-group-prepend">
                    <div class="input-group-text ps-3"><i class="bi bi-calendar2-week-fill"></i> </div>
                </div>
                <input id="calendar-date-input" type="text" class="form-control hasdatetimepicker" placeholder="YYYY/MM/DD">
            </div>
        </div>

        <div class="d-flex justify-content-center flex-wrap">

            <div class="cont-branch-calendar me-2">
                <select id="select-specialty-calendar" data-type="timeline" data-order="date" class="js-example-basic-single_branch select2-no-search_branch select2-hidden-accessible">
                    @foreach ($specialties as $iteam)
                    <option value="{{ $iteam->id }}" data-branch_name="{{ $iteam->name }}" data-branch_address="{{ $iteam->address }}">
                        {{ $iteam->name }}
                    </option>
                    @endforeach
                </select>
            </div>

            <div class="cont-branch-calendar me-2">
                <select id="select-branch-calendar" data-type="timeline" data-order="date" class="js-example-basic-single_branch select2-no-search_branch select2-hidden-accessible">

                    @if (Auth::user()->branch_id == 0)
                    @foreach ($branches as $iteam)
                    <option value="{{ $iteam->id }}" data-branch_name="{{ $iteam->name }}" data-branch_address="{{ $iteam->address }}">
                        {{ $iteam->name }}
                    </option>
                    @endforeach
                    @else
                    <option value="{{ Auth::user()->branch_id }}" data-branch_name="{{ Auth::user()->branch->name }}" data-branch_address="{{ Auth::user()->branch->address }}">
                        {{ Auth::user()->branch->name }}
                    </option>
                    @endif
                </select>
            </div>

            <div class="cont-branch-calendar me-2">
                <select id="select-unit-calendar" class="js-example-basic-single_branch select2-no-search_branch select2-hidden-accessible">
                </select>
            </div>

            <a href="{{ route('sett.appointment.create') }}" class="bg-white d-none d-md-block btn btn-sm shadow-sm b-r-l-cont p-2 px-4 text-gray-400"><i class="fas fa-plus fa-sm text-gray-300 me-1"></i> {{ __('basic.new') }}</a>
        </div>

    </div>

    <div class="card shadow mb-3 pb-2">

        <!-- Card Header - Dropdown -->
        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between border-0 pb-0">

            <div class="dropdown no-arrow">
                <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <div class="d-flex align-self-center me-2">
                        <h4 class="m-0 fw-bold clickable-item-pointer me-2 text-gray-200" id="click_monthly_calendar"><i class="bi bi-view-list"></i></h4>
                        <h4 class="m-0 fw-bold text-gray-700 clickable-item-pointer" id="click_timeline_calendar"><i class="bi bi-list-nested"></i></h4>
                    </div>
                </a>
            </div>

            <div class="dropdown no-arrow text-truncate" style="margin-top: -62px;">
                <a class="dropdown-toggle text-truncate" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <div class="d-flex align-self-center me-2 fs-6 text-truncate">
                        <a href="{{ route('sett.appointment.index') }}" class="m-0 fw-bold main-color me-2 text-truncate"> <i class="fas text-xs fa-circle"></i>
                            Appointments </a>
                        @role('Super-admin|Operation')
                        <a href="{{ route('sett.operation.index') }}" class="m-0 me-2 link-cust-text text-gray-200 text-truncate">Operations</a>
                        @endrole
                    </div>
                </a>
            </div>

            <div class="dropdown no-arrow" id="order-saved-date" data-order="timeline">
                <a class="dropdown-toggle" href="#" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <div class="d-flex align-self-center me-2">
                        <h4 class="m-0 fs-5 fw-bold clickable-item-pointer me-2 text-gray-200 click_order" data-type="arrived"><i class="fas fa-stethoscope"></i></h4>
                        <h4 class="m-0 fs-5 fw-bold clickable-item-pointer me-2 text-gray-200 click_order" data-type="accepted"><i class="fas fa-check"></i></h4>
                        <h4 class="m-0 fs-5 fw-bold clickable-item-pointer me-2 text-gray-200 click_order" data-type="notaccepted"><i class="fas fa-user-slash"></i></h4>
                        <h4 class="m-0 fs-5 fw-bold clickable-item-pointer me-2 text-gray-200 click_order" data-type="first_arrive"><i class="fas fa-sort-numeric-up-alt"></i></h4>
                        <h4 class="m-0 fw-bold clickable-item-pointer me-2 text-gray-200 click_order" data-type="status"><i class="bi bi-list-check"></i></h4>
                        <h4 class="m-0 fw-bold text-gray-200 text-gray-700 clickable-item-pointer click_order" data-type="timeline"><i class="bi bi-stopwatch"></i></h4>
                    </div>
                </a>
            </div>
        </div>


        <!-- showing waiting during ajax performance -->
        <div id="waiting" class="w-100 h-100 text-center" style="position: absolute; top:0px; left:0px;z-index:999999; background-color: #ffffffba;">
            <div class="spinner-grow text-primary" role="status" style="position: relative; top: 50%; transform: translateY(-50%);">
                <span class="sr-only">Loading...</span>
            </div>
        </div>


        <!-- Card Body for week calendar-->
        <div class="card-body pt-0" id="content_body_timeline">

            <div class="table-responsive">

                <table class="table table-bordered table-weekly-calender">
                    <thead>
                        <tr id="calander_cont_header">
                            <!-- week calaendar content from ajax -->
                        </tr>
                    </thead>
                </table>

            </div>

            <div class="row">
                <div class="fs-4 text-gray-300 me-3">
                    <h4 id="day_name_welcome" class="mb-0"></h4>
                    <p id="day_number_welcome" class="fs-1 text-gray-500 me-3 mb-0"></p>
                </div>
                <div class="col-12 col-md px-2 pe-0 pe-md-5 px-2 px-md-4" id="timeslots_calendar_cont">
                    <!-- timeslots and appointment info content from ajax -->
                </div>
                {{--
                <div id="welcome_cont" class="col-12 col-md-5 px-3 align-self-start"
                    style="margin-left: auto;margin-right: auto;" id="welc_msg_div">
                    <div id="welc_msg_avatar"></div>

                    <div class="d-flex justify-content-between">
                        <div class="fs-4 text-gray-300 me-3">
                            <h4 id="day_name_welcome"></h4>
                            <p id="day_number_welcome" class="fs-1 text-gray-500 me-3"></p>
                        </div>
                        <div id="welc_msg_timeslot" class="fs-4 text-gray-300 text-end"></div>
                    </div>
                    <div id="patient_show_calendar">
                        <img class="img-fluid p-md-2 mb-2"
                            src="{{ URL::asset('img/dashboard/undraw_chore_list_re_2lq8.svg') }}" alt=""
                style="margin-top:-51px;">
                <h2 class="welcome-msg-text text-center fw-light text-gray-300">
                    {{ __('patientappo.welcome calaendar') }}
                </h2>
                <hr>
                <p id="total_num_services" class="text-gray-300 text-s text-center"></p>
            </div>
        </div> --}}

    </div>

</div>

<!-- Card Body for monthly calendar-->
<div class="card-body pt-0 px-1 px-md-4" id="content_body_month_cont" style="display: none">

    <div id="content_body_month">

    </div>

    <div class="row p-3 p-md-4">
        <span class="col text-s text-gray-400"><i class="fas fa-circle not_accepted-color"></i>
            {{ __('patientappo.not accepted') }}</span>
        <span class="col text-s text-gray-400"><i class="fas fa-circle main-color"></i>
            {{ __('patientappo.accepted') }}</span>
        <span class="col text-s text-gray-400"><i class="fas fa-circle arrived-color"></i>
            {{ __('patientappo.arrived') }}
        </span>
        <span class="col text-s text-gray-400"><i class="fas fa-circle inprog-color"></i>
            {{ __('patientappo.with doctor') }}</span>
        <span class="col text-s text-gray-400"><i class="fas fa-circle done-color"></i>
            {{ __('patientappo.done') }}</span>
        <span class="col text-s text-gray-400 mt-2 mt-md-0"><i class="fas fa-circle notresp-color"></i>
            {{ __('patientappo.not respond') }}</span>
        <span class="col text-s text-gray-400"><i class="fas fa-circle cancel-color"></i>
            {{ __('patientappo.canceled') }}
        </span>
    </div>

</div>

</div>



<!-- Modal for appointment info -->
<div class="modal side_modal_prox fade" id="sidemodal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog shadow modal-dialog-scrollable">
        <div class="modal-content shadow" id="sidemodal_content">
            <!-- the data comes from ajax -->
        </div>
    </div>
</div>



<!-- Modal lab insert data -->
<div class="modal fade" id="follow_up_app_modal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable">

        <form action="{{ route('sett.follow_up_app_index') }}" method="post" style="display: contents">
            {{ method_field('POST') }}
            {{ csrf_field() }}

            <div class="modal-content b-r-s-cont border-0">
                <div class="modal-header">
                    <h5 class="modal-title" id="exampleModalLabel"><i class="fas fa-calendar-alt me-1"></i>
                        {{ __('basic.follow up appointment') }}
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>

                <!-- Modal content -->
                <div class="modal-body px-5 py-3">

                    <div class="row mb-2">

                        <div class="col-12 mb-2">
                            <label class="form-label">{{ __('basic.appointment') }}
                                <small>({{ __('basic.required') }})</small></label>
                            <select class="myselect2-follow_up select2-hidden-accessible @error('followup_app_day') is-invalid @enderror" name="followup_app_day" required>
                                <option value="3">
                                    3 Days
                                </option>
                                <option value="7">
                                    7 Days
                                </option>
                                <option value="10">
                                    10 Days
                                </option>
                                <option value="15">
                                    15 Days
                                </option>
                                <option value="30">
                                    A Month
                                </option>
                                <option value="60">
                                    2 Months
                                </option>
                                <option value="90">
                                    3 Months
                                </option>
                                <option value="180">
                                    6 Months
                                </option>
                            </select>

                            <span id="followup_app_day_error" class="error-msg-form"></span>

                            @error('followup_app_day')
                            <span class="error-msg-form">
                                {{ $message }}
                            </span>
                            @enderror
                        </div>

                        <div class="col-12 mb-2">
                            <label class="form-label">{{ __('basic.appointment note') }}
                                <small>({{ __('basic.optional') }})</small></label>
                            <textarea name="appintment_note" class="form-control" placeholder="Write here your notes .." rows="4" spellcheck="false"></textarea>

                            <span id="session_cat_invoice_error" class="error-msg-form"></span>

                            @error('appintment_note')
                            <span class="error-msg-form">
                                {{ $message }}
                            </span>
                            @enderror

                        </div>

                    </div>

                    <input id="follow_up_app_id_modal" name="fw_appointment_id" type="hidden">

                </div>

                <div class="modal-footer">
                    <div class="left-side">
                        <button type="button" class="btn btn-default btn-link" data-bs-dismiss="modal">{{
                                __('basic.never mind') }}</button>
                    </div>
                    <div class="divider"></div>
                    <div class="right-side">
                        <button type="submit" class="btn btn-default btn-link main-color">Add
                            New</button>
                    </div>
                </div>
            </div>
        </form>

    </div>

</div>
</div>

@endsection

<!-- js insert -->
@section('js')

<script src="https://fastly.jsdelivr.net/npm/sortablejs@latest/Sortable.min.js"></script>
<script src="https://fastly.jsdelivr.net/npm/jquery-sortablejs@latest/jquery-sortable.js"></script>

<script>
    $(document).ready(function() {

        // var el = document.getElementById('items');

        // var sortable = Sortable.create(el, {

        //     // Element dragging ended
        //     onEnd: function (/**Event*/evt) {
        //         var itemEl = evt.item;  // dragged HTMLElement
        //         evt.to;    // target list
        //         evt.from;  // previous list
        //         evt.oldIndex;  // element's old index within old parent
        //         evt.newIndex;  // element's new index within new parent
        //         evt.oldDraggableIndex; // element's old index within old parent, only counting draggable elements
        //         evt.newDraggableIndex; // element's new index within new parent, only counting draggable elements
        //         evt.clone // the clone element
        //         evt.pullMode;  // when item is in another sortable: `"clone"` if cloning, `true` if moving
        //         var qwewewq = $(evt.to).data("attr");
        //         //console.log(qwewewq + 'asdasd');
        //     },

        // });


    });
</script>
<!-- select 2 -->
<script src="https://fastly.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js">
</script>
<script>
    $(document).ready(function() {
        $('.js-example-basic-single_branch').select2();
        //hide search
        $('.select2-no-search_branch').select2({
            minimumResultsForSearch: -1
        });
    });
</script>

<!-- jquery ui datepicker -->
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
<script>
    $(function() {
        $('.hasdatetimepicker').datepicker({
            todayHighlight: true,
            format: "yyyy-mm-dd",
        });
    });
</script>

<!-- delete confirmation modal -->
<script>
    $('.delete-conf').click(function(event) {
        var user_id = $(this).data("user_id");
        var username = $(this).data("username");
        console.log(user_id);
        var modal = $('.delete-conf-input [name="user_id"]')
        modal.val(user_id);
        $('#username').val(username);
    })
</script>


<script>
    //--------------------- calander arrows appointment ajax -------------------
    $(document).ready(function() {

        fetchWeeklyCalander();

        function fetchWeeklyCalander(yearin = null, weekin = null) {

            var url = "{{ route('sett.app_weekly_calender', [':year', ':week']) }}";
            url = url.replace(':year', yearin).replace(':week', weekin);

            $.ajax({
                url: url,
                type: "GET",
                success: function(data) {
                    $("#calander_cont_header").html(data);
                }
            });
        };

        //reinsert the calander week days when the month arrows are clicked
        $(document).on('click', '#change_week', function() {
            var yearin = $(this).data('year');
            var weekin = $(this).data('week');
            fetchWeeklyCalander(yearin, weekin)
        });


        //to get unit depnds on branch selected

        fetchUnit();

        function fetchUnit(branch = $('#select-branch-calendar').val()) {

            var url = "{{ route('sett.app_fetch_unit_ajax', [':date']) }}";
            url = url.replace(':date', branch);

            $.ajax({
                url: url,
                type: "GET",
                dataType: "json",
                success: function(data) {
                    $('#select-unit-calendar').html(
                        '<option value="all"> All Units</option>');
                    $.each(data, function(key, value) {
                        $('#select-unit-calendar').append('<option value="' +
                            value.id + '">' + value.name + '</option>');
                    });
                    $('#select-unit-calendar').append(
                        '<option value="0"> Witing List</option>');

                    var year = $('#fetch-date-calendar-branch').data('year');
                    var month = $('#fetch-date-calendar-branch').data('month');
                    var day = $('#fetch-date-calendar-branch').data('day');
                    fetchTimeslotsCalander(year, month, day)
                }
            });
        }
        //------ appointment time slots ------

        var branch_id = $('#select-branch-calendar').val();
        var unit_id = $('#select-unit-calendar').val();
        var specialty_id = $('#select-specialty-calendar').val();

        fetchTimeslotsCalander();

        //for showing loading icon until the ajax is done
        $(document).ajaxStart(function() {
            $("#waiting").show();
        });

        $(document).ajaxStop(function() {
            $("#waiting").hide();
        });





        sortable_calendar();

        function sortable_calendar() {

            $('#fetch-date-calendar-branch').sortable({
                animation: 150,
                // ghostClass: 'bg-light-blue',
                onEnd: function( /**Event*/ evt) {
                    var itemEl = evt.item; // dragged HTMLElement
                    evt.to; // target list
                    evt.from; // previous list
                    evt.oldIndex; // element's old index within old parent
                    evt.newIndex; // element's new index within new parent
                    evt.oldDraggableIndex; // element's old index within old parent, only counting draggable elements
                    evt.newDraggableIndex; // element's new index within new parent, only counting draggable elements
                    evt.clone // the clone element
                    evt.pullMode; // when item is in another sortable: `"clone"` if cloning, `true` if moving

                    var item_id = $(evt.item).data("id");
                    var item_index = evt.newIndex;

                    var url = "{{ route('sett.sortable_calendar_update', ':id') }}";
                    url = url.replace(':id', item_id);

                    var item_orders = "";

                    $("#fetch-date-calendar-branch .item_calendar_fetch").each(function(i) {
                        if (item_orders == '') {
                            item_orders = $(this).attr('data-id');
                        } else {
                            item_orders += "," + $(this).attr('data-id');
                        }
                    });

                    $.ajax({
                        url: url,
                        type: "POST",
                        data: {
                            '_token': "{{ csrf_token() }}",
                            '_method': "POST",
                            'id': item_id,
                            'item_orders': item_orders,
                        },
                        success: function(data) {}
                    });
                },

            });
        }

        function fetchTimeslotsCalander(year = {
            {
                date('Y')
            }
        }, month = {
            {
                date('m')
            }
        }, day = {
            {
                date('d')
            }
        }, specialty = $('#select-specialty-calendar').val(), branch = $(
            '#select-branch-calendar').val(), unit = $('#select-unit-calendar').val(), order = $(
            '#select-specialty-calendar').attr('data-order')) {
            var url =
                "{{ route('sett.app_weekly_calender_date', [':year_re', ':month_re', ':day_re', ':specialty_id', ':branch_id', ':unit_id', ':order_re']) }}";
            url = url.replace(':year_re', year).replace(':month_re', month).replace(':day_re', day).replace(
                ':specialty_id', specialty).replace(':branch_id', branch).replace(':unit_id', unit).replace(
                ':order_re', order);

            var url2 =
                "{{ route('sett.app_weekly_calender_date_total_services', [':year_re', ':month_re', ':day_re', ':specialty_id', ':branch_id', ':unit_id']) }}";
            url2 = url2.replace(':year_re', year).replace(':month_re', month).replace(':day_re', day).replace(
                ':specialty_id', specialty).replace(':branch_id', branch).replace(':unit_id', unit);;

            $("#day_name_welcome").html(day_name_welcome)
            $.ajax({
                url: url,
                type: "GET",
                success: function(data) {
                    $("#timeslots_calendar_cont").html(data);

                    var day_number_welcome = $('#fetch-date-calendar-branch').data('day');
                    var day_name_welcome = $('#fetch-date-calendar-branch').data('day_name');

                    $("#day_name_welcome").html(day_name_welcome);
                    $("#day_number_welcome").html(day_number_welcome);

                    $.ajax({
                        url: url2,
                        type: "GET",
                        success: function(data) {
                            var total_num = '';
                            $.each(data, function(key, value) {
                                total_num +=
                                    '<span class="me-1"><i class="fas fa-circle text-xxs me-1 text-gray-200"></i>' +
                                    value
                                    .service_item.name +
                                    ': ' + value.total + '</span>';
                            });
                            sortable_calendar();

                            $("#total_num_services").html(total_num);
                        }
                    });

                    window.timer = setTimeout(function() {
                        fetchTimeslotsCalander();
                    }, 1000000);
                }
            });

        };

        //reinsert the timeslots when the days arrows are clicked
        $(document).on('click', '#change_calendar_timeslots', function() {

            var year = $(this).data('year');
            var month = $(this).data('month');
            var day = $(this).data('day');

            $('.calendar_weekly_normal').removeClass('calendar_weekly_selected');
            $(this).addClass('calendar_weekly_selected');
            var branch_id = $('#select-branch-calendar').val();
            var specialty_id = $('#select-specialty-calendar').val();
            var unit_id = $('#select-unit-calendar').val();

            clearTimeout(window.timer);

            fetchTimeslotsCalander(year, month, day, specialty_id, branch_id, unit_id)
        });



        //reinsert timeslots appointment when branch selector is changed
        $(document).on('change', '#select-specialty-calendar', function() {

            var type = $(this).attr('data-type');

            var year = $('#fetch-date-calendar-branch').data('year');
            var month = $('#fetch-date-calendar-branch').data('month');
            var day = $('#fetch-date-calendar-branch').data('day');
            var specialty = $(this).val();
            var branch = $('#select-branch-calendar').val();
            var unit = $('#select-unit-calendar').val();
            var order = $(this).attr('data-order');

            if (type === 'timeline') {
                clearTimeout(window.timer);
                fetchTimeslotsCalander(year, month, day, specialty, branch, unit, order)

            } else {
                var month = $(this).attr('data-month');
                var year = $(this).attr('data-year');
                var specialty = $(this).val();
                var branch = $('#select-branch-calendar').val();
                clearTimeout(window.timer);
                monthly_calendar(month, year, specialty, branch, unit);
            }

        });

        //reinsert timeslots appointment when branch selector is changed
        $(document).on('change', '#select-branch-calendar', function() {

            var type = $(this).attr('data-type');

            var year = $('#fetch-date-calendar-branch').data('year');
            var month = $('#fetch-date-calendar-branch').data('month');
            var day = $('#fetch-date-calendar-branch').data('day');
            var specialty = $('#select-specialty-calendar').val();
            var branch = $(this).val();
            var unit = $('#select-unit-calendar').val();
            var order = $(this).attr('data-order');

            fetchUnit();

            if (type === 'timeline') {
                clearTimeout(window.timer);
            } else {
                clearTimeout(window.timer);
                monthly_calendar(month, year, specialty, branch, unit);
            }

        });

        //reinsert timeslots appointment when branch selector is changed
        $(document).on('change', '#select-unit-calendar', function() {

            var type = $('#select-branch-calendar').attr('data-type');
            var year = $('#fetch-date-calendar-branch').data('year');
            var month = $('#fetch-date-calendar-branch').data('month');
            var day = $('#fetch-date-calendar-branch').data('day');
            var specialty = $('#select-specialty-calendar').val();
            var branch = $('#select-branch-calendar').val();
            var unit = $(this).val();
            var order = $('#select-branch-calendar').attr('data-order');

            if (type === 'timeline') {
                clearTimeout(window.timer);
                fetchTimeslotsCalander(year, month, day, specialty, branch, unit, order)
            } else {
                clearTimeout(window.timer);
                monthly_calendar(month, year, specialty, branch, unit);
            }

        });







        //reinsert the timeslots table when the date paicker are changed
        $(document).on('change', '#calendar-date-input', function() {
            var date = $(this).val().split('-');
            var year = date[0];
            var month = date[1];
            var day = date[2];
            var branch_id = $('#select-branch-calendar').val();
            var specialty_id = $('#select-specialty-calendar').val();
            var unit_id = $('#select-unit-calendar').val();

            clearTimeout(window.timer);
            clearTimeout(timer);

            fetchTimeslotsCalander(year, month, day, specialty_id, branch_id, unit_id);
        });

        //get the appontment info in wlc msg place when the appointment in timeslots is clicked
        $(document).on('click', '#weekly_calendar_fetch_pat', function() {

            paying_txt = "{{ __('basic.paying') }}";

            var id = $(this).data('id');
            var year = $(this).data('year');
            var month = $(this).data('month');
            var day = $(this).data('day');

            var url = "{{ route('sett.app_appointment_info_ajax', ':id') }}";
            url = url.replace(':id', id);

            //$(window).scrollTop($('#welc_msg_avatar').position().top);

            $.ajax({
                url: url,
                type: "GET",
                dataType: "json",
                success: function(data) {
                    avatar_url = '{{ URL::asset('
                    img / useravatar ') }}';
                    edit_url =
                        '{{ route('
                    sett.appointment.edit ', ': id ') }}';
                    edit_url = edit_url.replace(':id', data.appointment.id);

                    if (data.appointment.invoice_item) {
                        url_invoice =
                            '{{ route('
                        sett.invoice.show ', ': id ') }}';
                        url_invoice = url_invoice.replace(':id', data.appointment
                            .invoice_item.invoice.id);
                    } else {
                        url_invoice = "";
                    }

                    url_patient =
                        '{{ route('
                    sett.patient.show ', ': id ') }}';
                    url_patient = url_patient.replace(':id', data.appointment.patient_id);

                    url_appointment =
                        '{{ route('
                    sett.appointment.show ', ': id ') }}';
                    url_appointment = url_appointment.replace(':id', data.appointment.id);

                    var doctors_ajax = '';

                    if (data.appointment.doctor !== null) {
                        var doctor_name = data.appointment.doctor.name;
                        var doctor_id = data.appointment.doctor.id;
                    } else {
                        var doctor_name = '{{ __('
                        basic.not selected ') }}';
                    }

                    if (data.appointment.creator !== null) {
                        var creator_name = data.appointment.creator.name;
                    } else {
                        var creator_name = '{{ __('
                        basic.patient ') }}';
                    }

                    if (data.appointment.last_update_person !== null) {
                        var last_update_person_name = data.appointment.last_update_person
                            .name;
                    } else {
                        var last_update_person_name = 'No One';
                    }

                    if (data.appointment.invoice_item) {

                        var url_invoice_html = '<a href="' + url_invoice +
                            '" class="dropdown-item btn modal-effect text-gray-400 text-xs"><i class="fas fa-file-invoice-dollar me-1"></i>{{ __('
                        basic.invoice ') }}</a>';

                        if (data.appointment.invoice_item.invoice.status == 0) {
                            var payment_status = data.appointment.invoice_item.invoice.code;
                            var edit_appointment = '<a href="' + edit_url +
                                '" class="dropdown-item btn modal-effect text-gray-400 text-xs"><i class="bi bi-calendar2-week-fill me-1"></i>{{ __('
                            basic.edit date ') }}</a>';
                        } else {
                            var payment_status = '{{ __('
                            basic.paid ') }}';
                            var edit_appointment = '';
                        }
                    } else {
                        var url_invoice_html = '';
                        var payment_status = 'No fees';
                        var edit_appointment = '<a href="' + edit_url +
                            '" class="dropdown-item btn modal-effect text-gray-400 text-xs"><i class="bi bi-calendar2-week-fill me-1"></i>{{ __('
                        basic.edit date ') }}</a>';
                    }

                    var after_days_appointment =
                        '<a data-app_id="' + data.appointment.id +
                        '" class="follow_up_appointment dropdown-item btn modal-effect text-gray-400 text-xs"><i class="bi bi-calendar2-week-fill me-1"></i>{{ __('
                    basic.follow up appointment ') }}</a>';

                    if (data.appointment.meet_start_url) {
                        var url_start_online = '<a target="_blank" href="' + data
                            .appointment
                            .meet_start_url +
                            '" class="dropdown-item btn modal-effect text-gray-400 text-xs"><i class="fas fa-video me-1"></i>Start Online video</a>';

                        var url_join_online =
                            '<a target="_blank" href="' +
                            data.appointment
                            .meet_join_url +
                            '" class="dropdown-item btn modal-effect text-gray-400 text-xs copy_clipboard"><i class="fas fa-video me-1"></i>Copy join Online video</a>';
                    } else {
                        var url_start_online = '';
                        var url_join_online = '';
                    }

                    $.each(data.doctors, function(key, value) {
                        doctors_ajax += '<option value="' + value.id + '"' +
                            (value.id == doctor_id ? 'selected' :
                                'another possibility') +
                            '>' + value.name + ' </option>';
                    })

                    $("#sidemodal_content").html(
                        '<div class="modal-header">' +
                        '<h5 class="modal-title" id="exampleModalLabel">Appointment Info</h5>' +
                        '<button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>' +
                        '</div>' +
                        '<div class="modal-body px-5">' +
                        '<div id="welc_msg_avatar"><div class="row">' +
                        '<div class="col text-center mb-2">' +

                        '<div class="text-end position-relative">' +
                        '<div class="dropdown no-arrow">' +
                        '<a class="dropdown-toggle" role="button" id="dropdownMenuLink" data-bs-toggle="dropdown" aria-haspopup="true" aria-expanded="false">' +
                        '<i class="fas fa-ellipsis-v fa-sm fa-fw text-gray-300" style=" width: 38px; height: 18px; "></i></a>' +
                        '<div class="dropdown-menu shadow animated--fade-in" aria-labelledby="dropdownMenuLink">' +
                        '<a href="' + url_appointment +
                        '" class="dropdown-item btn modal-effect text-gray-400 text-xs"><i class="bi bi-calendar2-week-fill me-1"></i>Show</a>' +
                        edit_appointment + url_invoice_html + url_start_online +
                        url_join_online + after_days_appointment +
                        '</div></div></div>' +
                        '<img class="rounded-circle avatar-lg mb-2"' +
                        'src=' + avatar_url + '/' + data.appointment.patient.avatar +
                        '> <div><p class = "mb-0 text-xs text-gray-300 ">{{ __('
                        basic.patient ') }} </p> <a href="' +
                        url_patient + '" class="mb-0 text-m fw-bold text-gray-600 " >' +
                        data.appointment.patient.name +
                        '</a> <p class = "mb-0 text-xs text-gray-400 fw-bold">' +
                        data.appointment.patient.phone_number +
                        '</p> </div> </div>' +
                        '</div><hr>' +

                        '<div class="d-flex justify-content-between">' +
                        '<div class="fs-4 text-gray-300 me-3"><h4>' + data.day_name +
                        '<h4>' +
                        '<p class="fs-1 text-gray-500 me-3"> ' + data.day_month +
                        ' </p>' +
                        '</div>' +
                        '<div id="welc_msg_timeslot" class="fs-4 text-gray-300 text-end align-self-center">' +
                        '<div class="mb-1"><span class="text-s">{{ __('
                        basic.from ') }} </span><span>' +
                        data.start +
                        '</span></div><div class=""><span class="text-s">{{ __('
                        basic.to ') }} </span><span>' +
                        data.end +
                        '</span></div></div>' +
                        '</div>' +
                        '</div>' +
                        '<hr>' +

                        '<div id="patient_show_calendar" class="text-center">' +

                        //update
                        '<div class="text-center d-flex justify-content-between mt-2">' +
                        '<div class="text-start mb-2 me-2"> <div class="text-xs text-gray-300 mb-1">{{ __('
                        basic.unit ') }}</div>  <div class="text-s text-gray-600 mb-1">' +
                        data.appointment.unit.name +
                        '</div> </div>' +
                        '<div class="text-start mb-2 me-2"> <div class="text-xs text-gray-300 mb-1">{{ __('
                        basic.service ') }}</div>  <div class="text-s text-gray-600 mb-1">' +
                        data.appointment.service_item.name +
                        '</div> </div>' +
                        '<div class="text-start mb-2 me-2"> <div class="text-xs text-gray-300 mb-1">{{ __('
                        basic.payment ') }}</div>  <div class="text-s text-gray-600 mb-1">' +
                        payment_status +
                        '</div> </div>' +
                        '<div class="text-start mb-2 me-2"> <div class="text-xs text-gray-300 mb-1">{{ __('
                        basic.created ') }}</div>  <div class="text-s text-gray-600 mb-1">' +
                        data.created +
                        '</div> </div>' +

                        '</div>' +
                        '<hr>' +

                        '<div class="text-center d-flex justify-content-between mt-2">' +
                        '<div class="text-start mb-2 me-2"> <div class="text-xs text-gray-300 mb-1">{{ __('
                        basic.creator ') }}</div>  <div class="text-s text-gray-600 mb-1">' +
                        creator_name +
                        '</div> </div>' +
                        '<div class="text-start mb-2"> <div class="text-xs text-gray-300 mb-1">{{ __('
                        basic.last update ') }}</div>  <div class="text-s text-gray-600 mb-1">' +
                        last_update_person_name +
                        '</div> </div>' +
                        '<div class="text-start mb-2 me-2"> <div class="text-xs text-gray-300 mb-1">{{ __('
                        basic.updated ') }}</div>  <div class="text-s text-gray-600 mb-1">' +
                        data.updated +
                        '</div> </div>' +
                        '</div>' +

                        '<hr>' +

                        '<div class="text-center cont-branch-calendar mt-2">' +

                        '<div class="text-start mb-3"> <div class="text-xs text-gray-300 mb-1">{{ __('
                        basic.status ') }}</div>' +

                        '<select id="select-status-calendar" class="js-example-basic-single select2-no-search select2-hidden-accessible">' +

                        '<option value="0"' +
                        (data.appointment.status == 0 ? 'selected' :
                            'another possibility') +
                        '>{{ __('
                        patientappo.not accepted ') }}</option>' +

                        '<option value="1"' +
                        (data.appointment.status == 1 ? 'selected' :
                            'another possibility') +
                        '>{{ __('
                        patientappo.accepted ') }}</option>' +

                        '<option value="2"' +
                        (data.appointment.status == 2 ? 'selected' :
                            'another possibility') +
                        '>{{ __('
                        patientappo.arrived ') }}</option>' +

                        '<option value="3"' +
                        (data.appointment.status == 3 ? 'selected' :
                            'another possibility') +
                        '>{{ __('
                        patientappo.with doctor ') }}</option>' +

                        '<option value="4"' +
                        (data.appointment.status == 4 ? 'selected' :
                            'another possibility') +
                        '>{{ __('
                        patientappo.done appointment ') }}</option>' +

                        '<option value="5"' +
                        (data.appointment.status == 5 ? 'selected' :
                            'another possibility') +
                        '>{{ __('
                        patientappo.not respond ') }}</option>' +

                        '<option value="6"' +
                        (data.appointment.status == 6 ? 'selected' :
                            'another possibility') +
                        '>{{ __('
                        patientappo.canceled ') }}</option>' +

                        '</select>' +

                        '</div><div class="text-start mb-4"> <div class="text-xs text-gray-300 mb-1">{{ __('
                        basic.doctor ') }}</div>' +


                        '<select id="select-doctor-calendar" class="js-example-basic-single select2-no-search select2-hidden-accessible">' +
                        '<option disabled selected>{{ __('
                        basic.not selected ') }}</option>' +
                        doctors_ajax +
                        '</select>' +

                        '</div>' +
                        //  end of docto selector
                        '</div>' +

                        '<div class="text-start mb-3"> <div class="text-xs text-gray-300 mb-1">{{ __('
                        basic.note ') }}</div>' +

                        '<textarea id="select-note-calendar" name="note" class="form-control" placeholder="Write here your notes .." rows="4" spellcheck="false">' +
                        data.appointment.note +
                        '</textarea>' +

                        //  end of note
                        '</div>' +

                        '</div>' +

                        '</div>' +
                        '<div class="modal-footer">' +
                        '<span class="text-gray-300 clickable-item-pointer me-3" data-bs-dismiss="modal">Close</span>' +
                        '<button type="button" id="calendar_info_sub" data-id="' + data
                        .appointment.id +
                        '" data-year="' +
                        year + '" data-month="' + month + '" data-day="' + day +
                        '" class="btn btn-primary px-5" >Save changes</button>' +
                        '</div>'
                    );

                    $('#sidemodal').modal('show');

                    $('.js-example-basic-single').select2({
                        dropdownParent: $("#sidemodal")
                    });
                    //hide search
                    $('.select2-no-search').select2({
                        dropdownParent: $("#sidemodal"),
                        minimumResultsForSearch: -1
                    });

                }
            });


        });

        //reinsert the calander when the date paicker are changed
        $(document).on('click', '#calendar_info_sub', function() {

            var appointment_id = $(this).data('id');
            var status = $(this).parent().parent().find('.modal-body').find('#select-status-calendar')
                .val();
            var doctor = $(this).parent().parent().find('.modal-body').find('#select-doctor-calendar')
                .val();;

            var note = $(this).parent().parent().find('.modal-body').find('#select-note-calendar')
                .val();;

            var year = $(this).data('year');
            var month = $(this).data('month');
            var day = $(this).data('day');

            var url = "{{ route('sett.app_update_status_doctor', ':id') }}";
            url = url.replace(':id', appointment_id);

            $.ajax({
                url: url,
                type: "POST",
                data: {
                    '_token': "{{ csrf_token() }}",
                    '_method': "PATCH",
                    'status': status,
                    'doctor': doctor,
                    'note': note,
                },
                success: function(data) {
                    if (data.querystatue == true) {
                        var specialty_id = $('#select-specialty-calendar').val();
                        var branch_id = $('#select-branch-calendar').val();
                        fetchTimeslotsCalander(year, month, day, specialty_id, branch_id);
                        $('#sidemodal').modal('hide');
                    }
                }
            });

        });

        //for follow up appointment modal
        $(document).on('click', '.follow_up_appointment', function() {

            var appointment_id = $(this).data('app_id');


            $('#follow_up_app_id_modal').val(appointment_id);
            $('#sidemodal').modal('hide');
            $('#follow_up_app_modal').modal('show');
        });

        //hide search
        $('.myselect2-follow_up').select2({
            dropdownParent: $("#follow_up_app_modal"),
            minimumResultsForSearch: -1
        });


        // ----- change timeline slots order -----

        //reinsert calander when branch selector is changed (#branches_selc_form)
        $(document).on('click', '.click_order', function() {

            //change color on click
            $('.click_order').removeClass('text-gray-700');

            $(this).addClass('text-gray-700');

            //fetch-date-calendar-branch it is in contraller and we fetch it by ajax
            var year = $('#fetch-date-calendar-branch').data('year');
            var month = $('#fetch-date-calendar-branch').data('month');
            var day = $('#fetch-date-calendar-branch').data('day');
            var specialty_id = $('#select-specialty-calendar').val();
            var branch_id = $('#select-branch-calendar').val();
            var unit_id = $('#select-unit-calendar').val();
            var order = $(this).data('type');

            //change the branch selector data attr to change the calendar
            $('#select-branch-calendar').attr('data-type', 'timeline');

            clearTimeout(window.timer);
            fetchTimeslotsCalander(year, month, day, specialty_id, branch_id, unit_id, order);
        });

        $(document).on('click', '#click_status_order', function() {

            //change color on click
            $(this).toggleClass('text-gray-200 text-gray-700');
            $('#click_date_order').toggleClass('text-gray-700 text-gray-200');

            var year = $('#fetch-date-calendar-branch').data('year');
            var month = $('#fetch-date-calendar-branch').data('month');
            var day = $('#fetch-date-calendar-branch').data('day');
            var specialty_id = $('#select-specialty-calendar').val();
            var branch_id = $('#select-branch-calendar').val();
            var unit_id = $('#select-unit-calendar').val();
            var order = 'status';

            //change the branch selector data attr to change the calendar
            $('#select-branch-calendar').attr('data-type', 'timeline');

            clearTimeout(window.timer);
            fetchTimeslotsCalander(year, month, day, specialty_id, branch_id, unit_id, order);
        });


        // ------------------ monthly calendar ------------------

        //--------------------- fetch appoingtments -------------------

        //reinsert calander when branch selector is changed (#branches_selc_form)
        $(document).on('click', '#click_timeline_calendar', function() {

            $('#content_body_month_cont').hide();
            $('#content_body_timeline').show();

            //change color on click
            $(this).toggleClass('text-gray-200 text-gray-700');
            $('#click_monthly_calendar').toggleClass('text-gray-700 text-gray-200');

            //change the branch selector data attr to change the calendar
            $('#select-branch-calendar').attr('data-type', 'timeline');
            $('#select-specialty-calendar').attr('data-type', 'timeline');

            clearTimeout(window.timer);
            fetchTimeslotsCalander();
        });


        //reinsert calander when branch selector is changed (#branches_selc_form)
        $(document).on('click', '#click_monthly_calendar', function() {

            $('#content_body_month_cont').show();
            $('#content_body_timeline').hide();

            $(this).toggleClass('text-gray-200 text-gray-700');
            $('#click_timeline_calendar').toggleClass('text-gray-700 text-gray-200');


            $('#select-branch-calendar').attr('data-type', 'month');
            $('#select-specialty-calendar').attr('data-type', 'month');

            clearTimeout(window.timer);

            monthly_calendar();
        });


        function monthly_calendar(month = {
            {
                date('m')
            }
        }, year = {
            {
                date('Y')
            }
        }, specialty = $(
            '#select-specialty-calendar').val(), branch = $(
            '#select-branch-calendar').val(), unit = $(
            '#select-unit-calendar').val()) {

            var url =
                "{{ route('sett.app_monthly_calendar_data', [':year_re', ':month_re', ':speicilty_re', ':branch_re', ':unit_re']) }}";
            url = url.replace(':year_re', year).replace(':month_re', month).replace(':speicilty_re', specialty)
                .replace(':branch_re', branch).replace(':unit_re', unit)

            $.ajax({
                url: url,
                type: "GET",
                success: function(data) {

                    $('#content_body_month').html(data);

                }

            })
        };

        //reinsert the month calander when the month arrows are clicked
        $(document).on('click', '#change_month', function() {

            var month = $(this).data('month');
            var year = $(this).data('year');
            var branch = $('#select-branch-calendar').val();

            $('#select-branch-calendar').attr('data-month', month)
            $('#select-branch-calendar').attr('data-year', year)

            monthly_calendar(month, year, branch)
        });


        //go from the day of monthly calendar to the same day of the timeline
        $(document).on('click', '.monthly_to_timeline_calendar', function() {

            var timeslot = $(this).data('timeslot');
            var specilty_id = $(this).data('specialty');
            var branch_id = $(this).data('branch');
            var arr = timeslot.split('-');

            var year = arr[0];
            var month = arr[1];
            var day = arr[2];

            //to show the timeline div and hide the monthly div
            $('#content_body_month_cont').hide();
            $('#content_body_timeline').show();

            //change color on click
            $('#click_timeline_calendar').toggleClass('text-gray-200 text-gray-700');
            $('#click_monthly_calendar').toggleClass('text-gray-700 text-gray-200');

            //change the branch selector data attr to change the calendar
            $('#select-specialty-calendar').attr('data-type', 'timeline');
            $('#select-branch-calendar').attr('data-type', 'timeline');

            clearTimeout(window.timer);
            fetchTimeslotsCalander(year, month, day, specilty_id, branch_id);

        });

    })
</script>

<!-- jquery ui datepicker -->
<script type="text/javascript" src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap-datepicker/1.4.1/js/bootstrap-datepicker.min.js"></script>
<script>
    $(function() {
        $('.hasdatetimepicker').datepicker({
            todayHighlight: true,
            format: "yyyy-mm-dd",
        }).on('change', function() {
            $('.datepicker').hide();
        });
    });
</script>

@endsection